/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */
 
#include "libri.h"

// Costruttore
Libri::Libri(const char* p_titolo){
	m_titolo = new char[strlen(t) + 1];
	strcpy(p_titolo, t);
}

// Costruttore di copia
Libri::Libri(const Libri& p_other){
	m_titolo = new char[strlen(p_other.m_titolo) + 1];
	strcpy(m_titolo, p_other.m_titolo);
}

 // Operatore di assegnazione copia
Libri& operator=(const Libri& p_other) {
	if (this != &p_other) {
		delete[] m_titolo;
		m_titolo = new char[strlen(p_other.m_titolo) + 1];
		strcpy(m_titolo, p_other.m_titolo);
	}
	return *this;
}

// Costruttore di move
Libri(Libri&& p_other) noexcept {
	m_titolo = p_other.m_titolo;     // Trasferimento del puntatore
	p_other.m_titolo = nullptr;      // Annullamento del sorgente
}

// Operatore di assegnazione move
Libri& operator=(Libri&& p_other) noexcept {
	if (this != &p_other) {
		delete[] m_titolo;            // Libero risorse attuali
		m_titolo = p_other.m_titolo;  // Trasferisco il puntatore
		p_other.m_titolo = nullptr;
	}
	return *this;
}

// Distruttore
Libri::~Libri(){
	delete[] m_titolo;
}