/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "controller.h"
#include "model.h"
	
void RubricaController::avvia() 
{
	int l_scelta;
		
	do {
			
		m_view.visualizzaMenu();
		l_scelta = m_view.getScelta();
			
		switch (l_scelta) 
		{
			case 1:{
				m_model.aggiungiContatto(m_view.inserisciContatto());
				break;
			}	
				
			case 2:{
				m_view.mostraContatti(m_model.getContatti());
				break;	
			}
				
			case 3:{
				m_model.eliminaPerNome(m_view.eliminaNome());
				break;
			}
				
			case 4:{
				m_model.salvaSuFile(m_filePath);
				break;
			}
				
			case 0:{
				cout << "Chiusura programma...\n";
				break;
			}
				
			default:
				cout << "Scelta non valida!\n";
		}
	} while (l_scelta != 0);
}