/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "model.h"

void RubricaModel::aggiungiContatto(Contatto p_contatto) 
{
	m_contatti.push_back(p_contatto);
}

vector<Contatto> RubricaModel::getContatti()
{
	return m_contatti;
}

bool RubricaModel::eliminaPerNome(string p_nome) 
{
	bool l_trovato = false;
	int  l_dimensioneContatti;
	int  l_position;
	
	l_position = -1;
	l_dimensioneContatti = m_contatti.size();
	
	for (int i=0; i < l_dimensioneContatti; i++)
	{
		if (m_contatti[i].nome == p_nome)
		{
			l_trovato = true;
			l_position = i;
			break;
		}
	}
	
	if (l_trovato)
	{
		m_contatti.erase(m_contatti.begin()+l_position);
	}
	
	return l_trovato;
}

void RubricaModel::caricaDaFile(string p_path) 
{
	string l_nome;
	string l_cognome; 
	string l_telefono;
	string l_email;
	string l_riga;
	
	ifstream l_file(p_path);
	
	if (!l_file.is_open()) 
	{
		cerr << "Errore: impossibile aprire il file \"" << p_path << "\".\n";
		return;
	}
	
	m_contatti.clear();
	
	while (getline(l_file, l_riga)) {
		
		stringstream l_ss(l_riga);
		
		getline(l_ss, l_nome, ',');
		getline(l_ss, l_cognome, ',');
		getline(l_ss, l_telefono, ',');
		getline(l_ss, l_email, ',');
		
		m_contatti.push_back({l_nome, l_cognome, l_telefono, l_email});
	}
}

void RubricaModel::salvaSuFile(string p_path)
{	
	ofstream l_file(p_path);	
	int l_dimensioneContatti;
	
	l_dimensioneContatti = m_contatti.size();
	
	for (int i=0; i<l_dimensioneContatti; i++){	
		l_file << m_contatti[i].nome << "," 
		<< m_contatti[i].cognome << "," 
		<< m_contatti[i].telefono << "," 
		<< m_contatti[i].email << "\n";
	}		
}