/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "view.h"

void RubricaView::visualizzaMenu()
{
	cout<<endl;
	cout << "MENU RUBRICA"<<endl;
	cout << "1. Aggiungi contatto\n";
	cout << "2. Visualizza tutti i contatti\n";
	cout << "3. Cancella contatto\n";
	cout << "4. Salva rubrica\n";
	cout << "0. Esci\n  Scelta: ";
	cin >> m_scelta;
}

Contatto RubricaView::inserisciContatto()
{
	Contatto l_nuovoContatto;
	
	cout << "Nome: "; 
	cin>>l_nuovoContatto.nome;
	cout<<endl;	
	cout << "Cognome: "; 
	cin>>l_nuovoContatto.cognome;
	cout<<endl;	
	cout << "Telefono: "; 
	cin>>l_nuovoContatto.telefono;
	cout<<endl;	
	cout << "Email: "; 
	cin>>l_nuovoContatto.email;
	
	return l_nuovoContatto;
}

void RubricaView::mostraContatti(vector<Contatto> p_contatti)
{
	for (int i=0; i< p_contatti.size();i++)
	{
		cout << (i+1) << ") " << p_contatti[i].nome << " " 
		     << p_contatti[i].cognome
		     << " | Tel: " << p_contatti[i].telefono 
		     << " | Email: " << p_contatti[i].email << endl;
	}
}

string RubricaView::eliminaNome()
{
	string l_nome;
	
	cout << "Nome da cancellare: "; 
	cin>>l_nome;
	
	return l_nome;
}

int RubricaView::getScelta()
{
	return m_scelta;
}