/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "BufferNoLeak.h"

Buffer::Buffer(size_t p_size)
{
	m_size = p_size;
	m_data = new char[p_size];
	
	cout << "[Costruttore] allocati " << m_size << " byte\n";
    memset(m_data, 0, m_size);
}

Buffer::Buffer(const Buffer& p_other)
{
    m_size = p_other.m_size;
    m_data = new char[p_other.m_size];
    
    cout << "[CopyCostr] copio " << m_size << " byte\n";
	memcpy(m_data, p_other.m_data, m_size);
}

Buffer& operator=(const Buffer& p_other)
{
    cout << "[CopyAssign] da " << m_size
         << " a " << p_other.size << " byte\n";
         
    if (this != &p_other) 
	{
        delete[] m_data;                      // 1 libera risorsa esistente
        m_size = p_other.m_size;              // 2 aggiorna dimensione
        m_data = new char[m_size];            // 3 rialloca
    	memcpy(m_data,p_other.m_data,m_size); // 4 copia contenuto
    }
    
    return *this;
}

Buffer::Buffer(Buffer&& p_other)
{
    m_data = p_other.m_data;
    m_size = p_other.m_size;
    
    cout << "[MoveCtor] sposto " << m_size << " byte\n";
    p_other.m_data = nullptr;  // impedisco al vecchio oggetto di deallocare
    p_other.m_size = 0;
}

Buffer::Buffer& operator=(Buffer&& p_other)
{
    cout << "[MoveAssign] sposto assegnando " << p_other.m_size << " byte\n";
    if (this != &p_other) 
	{
        delete[] m_data;          // libera risorsa corrente
        m_data = p_other.m_data;  // eredito il puntatore
        m_size = p_other.m_size;  // eredito la dimensione
        p_other.m_data = nullptr; // resetto l'oggetto sorgente
        p_other.m_size = 0;
    }
	    
    return *this;
}



Buffer::~Buffer()
{
	delete[] m_data;
    cout << "[Distruttore] deallocati " << m_size << " byte\n";
}