/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#ifndef   __BUFFER_NOLEAK_H__
#define   __BUFFER_NOLEAK_H__

#include <iostream>
#include <cstring>

using namespace std;

class Buffer
{
	// Stato della classe
	private:
		char*   m_data;
		size_t  m_size;
		
		// Interfaccia della classe
	public:
    	// Costruttore che alloca memoria
    	Buffer(size_t p_size);
     
		// Costruttore di copia
		Buffer(const Buffer& p_other);
		
		// Operatore =
		Buffer& operator=(const Buffer& p_other);
		
		// Costruttore di move
		Buffer(Buffer&& p_other);

		// Operatore di assegnazione di move
		Buffer& operator=(Buffer&& p_other);
		
    	// Distruttore che dealloca memoria
    	~Buffer(); 

};

#endif // __BUFFER_NOLEAK_H__