/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>
#include <stdlib.h>

#include "BufferNoLeak.h"

using namespace std;

int main(int argc, char** argv) {
	
	Buffer a(512);
    Buffer b = a;           // invoca copy constructor
    Buffer c(128);
    c = move(b);         // invoca move assignment
    Buffer d(move(a)); // invoca move constructor

    // Tutte le risorse vengono gestite correttamente, senza leak

	return EXIT_SUCCESS;
}

/* Main con leak
int main(int argc, char** argv) {

	
	Buffer buf1(1024);   // buf1.m_data punta a 1024 byte
    Buffer buf2(2048);   // buf2.m_data punta a 2048 byte

    buf1 = buf2;         // shallow copy del puntatore:
                         // buf1.m_data ora sovrascrive l'indirizzo originale
                         // la memoria di 1024 byte non viene mai liberata!
						 // Ho cosi' un memory leak di 1024 byte
	return EXIT_SUCCESS;
}
*/