/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "dbConnection.h"

DBConnection* DBConnection::getInstance() 
 {
    if (m_instance == NULL) 
	{
        m_instance = new DBConnection(); 
    }
    
    return m_instance;
}

sql::Connection* DBConnection::getConnection() 
{
    return m_conn;
}

DBConnection::DBConnection() 
{
        try 
		{
            m_driver = sql::mysql::get_driver_instance();
            m_conn = m_driver->connect("tcp://127.0.0.1:3306", "tuo_utente", "tua_password");
            m_conn->setSchema("nome_del_database");
            cout << "Connessione stabilita!\n";
        } 
		catch (sql::SQLException& e) 
		{	
        	cerr << "Errore: " << e.what() << endl;
            m_conn = NULL;
        }
}

DBConnection::~DBConnection() 
 {
    delete m_conn;
}