/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#ifndef   __DBCONNECTION_H__
#define   __DBCONNECTION_H__

#include <iostream>
#include <mysql_driver.h>
#include <mysql_connection.h>
#include <cppconn/exception.h>

using namespace std;

class DBConnection 
{
	public:
		// Metodo statico: controlla se l'istanza esiste, altrimenti la crea
		static DBConnection* getInstance();
		
		// Restituisce il puntatore alla connessione
    	sql::Connection* getConnection();
		 
	private:
		// Puntatore statico all'istanza
		static DBConnection*      m_instance;
		
		// Driver MySQL
    	sql::mysql::MySQL_Driver* m_driver;
		
		// Connessione al DB
    	sql::Connection*          m_conn; 
		
		// Costruttore privato
		DBConnection();
		
		// Distruttore
		~DBConnection();
		
		// Disabilita la copia e l'assegnazione
    	DBConnection(const DBConnection&) = delete;
    	DBConnection& operator=(const DBConnection&) = delete;
};

// Inizializzazione del puntatore statico
DBConnection* DBConnection::m_instance = NULL;

#endif // __DBCONNECTION_H__