/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>
#include <stdlib.h>

using namespace std;

/*
 * Funzione Divisione
 * Dati due numeri come parametri di ingresso p_dividendo e 
 *  p_divisore restituisce la divisione tra i due numeri
 *
 * @param  double p_dividendo
 * @param  double p_divisore
 *
 * @return double l_risultato
 *
 */
double divisione(double p_dividendo, double p_divisore)
{
	// Dichiarazione della variabile locale l_risultato
	double l_risultato;
	
	// Inizializzo la variabile locale l_risultato
	l_risultato = 0;
	
	// Istruzione per controllare il denominatore
	if (p_divisore == 0)
	{
		// Sequenza di istruzioni nel caso
		// il denominatore sia uguale a 0. 
		return EXIT_FAILURE;		
	}
	else
	{
		// Sequenza di istruzioni nel caso
		// il denominatore sia diverso da 0.
		l_risultato = p_dividendo / p_divisore;
		
	}
	
	return l_risultato;
}




int main(int argc, char** argv)
{
   	// Dichiarazione delle variabili
   double quoziente;
   double numeratore;
   double denominatore;
   
   // Inizializzazione delle variabili
   quoziente    = 0;
   numeratore   = 0;
   denominaotre = 1;
   
   // Inserisco da tastiera il valore del numeratore
   cout<<"Inserire il valore del numeratore:"<<endl;
   cin>>numeratore;
   
   // Inserisco da tastiera il valore del denominatore
   cout<<"Inserire il valore del denominatore:"<<endl;
   cin>>denominatore;
   
   //Calcolo la divisione richiamando la funzione 
   quoziente = divisione(numeratore,denominatore);
   
   if (quoziente == EXIT_FAILURE)
   {
   	cout<<"Errore : Non puoi dividere per zero!"<<endl;
   }
   else
   {
   	cout<<"Il risultato e' "<<quoziente<<endl;
   }

	return EXIT_SUCCESS; 
}