/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>
#include <vector>

using namespace std;

/// @brief Funzione stampaVettore
/// @brief Stampa il vettore preso in input
///
/// @param p_vettore
/// 
void stampaVettore(vector<int> &p_vettore)
{
    for (int i=0; i<p_vettore.size();i++)
    {
        cout<<p_vettore[i]<<" ";
    }

    cout<<endl;
}


/// @brief Funzione scambio
/// @brief Scambia il valore tra due variabili
/// @param p_primoValore 
/// @param p_secondoValore 
void scambio(int &p_primoValore, int &p_secondoValore)
{
    int l_temporanea;

    l_temporanea = p_primoValore;

    p_primoValore = p_secondoValore;

    p_secondoValore = l_temporanea;

}

/// @brief Funzione bubbleSort
/// @brief Prende in input un vettore e lo restituisce ordinato
///
/// @param p_vettore
/// 
/// @return l_vetoreOrdinato
///
vector<int> bubbleSort(vector<int> p_vettore)
{
    vector<int> l_vettoreOrdinato;

    int l_dimensioneVettore;

    l_vettoreOrdinato   = p_vettore;
    l_dimensioneVettore = l_vettoreOrdinato.size();

	cout<<endl;
	cout<<"Esecuzione del Bubble Sort:"<<endl;
    for (int i=0; i < (l_dimensioneVettore-1); i++)
    {
        for (int j=0 ; j < (l_dimensioneVettore-1-i); j++)
        {
            if (l_vettoreOrdinato[j+1]<l_vettoreOrdinato[j])
            {
                scambio(l_vettoreOrdinato[j+1],l_vettoreOrdinato[j]);
                cout<<"i = "<<i<<" j = "<<j<<endl;
                cout<<"Vettore: (scambio) ";
                stampaVettore(l_vettoreOrdinato);
            }
            else
            {
            	cout<<"i = "<<i<<" j = "<<j<<endl;
                cout<<"Vettore: ";
                stampaVettore(l_vettoreOrdinato);
			}
        }
    }

    return l_vettoreOrdinato;

}

/*
void stampaVettore(vector<int> &p_vettore)
{
    for (int i=0; i<p_vettore.size();i++)
    {
        cout<<p_vettore[i]<<" ";
    }

    cout<<endl;
}

*/

int main(int argc, char *argv[])
{
    vector<int> g_vettore= { 1,6,9,8,3 };
    vector<int> g_vettoreOrdinato;
    
    /*
    g_vettore.push_back(1);
    g_vettore.push_back(6);
    g_vettore.push_back(9);
    g_vettore.push_back(8);
    g_vettore.push_back(3);
*/
    cout<<"Vettore non ordinato: "<<endl;
    stampaVettore(g_vettore);

    g_vettoreOrdinato= bubbleSort(g_vettore);

    cout<<"Vettore ordinato: "<<endl;
    stampaVettore(g_vettoreOrdinato);
    
    
    system("PAUSE");
    return EXIT_SUCCESS;
}
