/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>

using namespace std;

//Variabili globali
int g_valore;
int g_fattoriale;

/*
 *  Funzione Fattoriale 
 *
 *	Calcola il fattoriale di un numero
 *
 * @param int p_valore
 *
 * @return int l_risultato
 *
 */
int fattoriale(int p_valore)
{
	int l_risultato=0;
	
	if (p_valore==0)
	{
		// Caso Base che fa terminare la ricorsione
		l_risultato = 1;
	}
	else
	{
		// Chiamata ricorsiva, la funzione richiama se stessa
		l_risultato = p_valore * fattoriale(p_valore-1);
	}
	
	return l_risultato;
}


int main(int argc, char** argv) {
	
	cout<<"Inserire un numero naturale: ";
	cin>>g_valore;
	
	g_fattoriale = fattoriale(g_valore);
	
	cout<<endl;
	cout<<g_valore<<"! = "<<g_fattoriale<<endl;
	cout<<endl;
	
	system("PAUSE");
	
	return EXIT_SUCCESS;
}

