/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>
#include <vector>

using namespace std;

vector<int> insertionSort(vector<int> p_vettore)
{

    /*
    Per l’ordinamento, si utilizza un ciclo esterno con indice i che parte da 1 
    e una variabile temporanea l_variabileDiAppoggio nella quale memorizziamo il secondo valore (a[1]). 
    L’indice j parte da 0.
    Quindi inizialmente i punta al secondo elemento mentre j punta al primo. 
    Dopo utilizziamo il while che si ripete finche' e' vera 
    questa condizione: (il valore puntato dall’indice j e' maggiore di l_variabileDiAppoggio e j>=0).
    All’interno del while memorizziamo il valore puntato dall’indice j nella posizione 
    successiva a j e decrementiamo j di 1.
    Quando si finisce il ciclo piu' interno (while) allora nella posizione j+1 memorizziamo 
    il valore di l_variabileDiAppoggio.
    Continuiamo finche' si verifica questa condizione: i<n.
    */

    vector<int> l_vettoreOrdinato;

    int l_dimensioneVettore;
    int l_variabileDiAppoggio;
    int j;

    l_vettoreOrdinato = p_vettore;
    l_dimensioneVettore = l_vettoreOrdinato.size();

    for(int i = 1; i < l_dimensioneVettore; i++) 
    { 
        l_variabileDiAppoggio = l_vettoreOrdinato[i]; 
        
        j = i - 1; 

        while((l_vettoreOrdinato[j] > l_variabileDiAppoggio) && (j >= 0)) 
        { 
            l_vettoreOrdinato[j + 1] = l_vettoreOrdinato[j]; 
            j--;
        } 

        l_vettoreOrdinato[j + 1] = l_variabileDiAppoggio;

    } 

    return l_vettoreOrdinato;
}

void stampaVettore(vector<int> p_vettore)
{
    for (int i=0; i<p_vettore.size();i++)
    {
        cout<<p_vettore[i]<<" ";
    }

    cout<<endl;
}


/* run this program using the console pauser or add your own getch, system("pause") or input loop */

int main(int argc, char** argv) {
	
	vector<int> g_vettore = { 1,8,6,3,9 };
    vector<int> g_vettoreOrdinato;

    cout<<"Vettore non ordinato: "<<endl;
    stampaVettore(g_vettore);

    g_vettoreOrdinato= insertionSort(g_vettore);

    cout<<"Vettore ordinato: "<<endl;
    stampaVettore(g_vettoreOrdinato);
	
	system("PAUSE");
	
    return EXIT_SUCCESS;
	
}