/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */
 
#include <iostream>
#include <vector>

using namespace std;

/// @brief  La funzione merge fonde due sotto vettore di p_vettore
/// @brief  primo sotto vettore e' p_vettore[p_estremoInf..p_meta]
/// @brief  secondo sotto vettore é p_vettore[p_meta+1..p_estremoSup]
/// @param p_vettore 
/// @param p_estremoInf 
/// @param p_meta 
/// @param p_estremoSup 
void merge(vector<int> &p_vettore, int p_estremoInf, int p_meta, int p_estremoSup)
{
    //Calcolo le dimensioni dei vettori temporanei
    int l_dimVettoreTemp1 = p_meta - p_estremoInf + 1;
    int l_dimVettoreTemp2 = p_estremoSup - p_meta;

    // Creo vettori temporanei
    vector<int> l_vettoreTemp1(l_dimVettoreTemp1), l_vettoreTemp2(l_dimVettoreTemp2);

    // Copia i dati nei vettori temporanei l_vettoreTemp1[] and l_vettoreTemp2[]
    for (int i = 0; i < l_dimVettoreTemp1; i++)
        l_vettoreTemp1[i] = p_vettore[p_estremoInf + i];
    for (int j = 0; j < l_dimVettoreTemp2; j++)
        l_vettoreTemp2[j] = p_vettore[p_meta + 1 + j];

    int i = 0, j = 0;
    int k = p_estremoInf;

    // Fondo i vettori temporanei 
    // dentro p_vettore[p_estremoInf..p_estremoSup]
    while (i < l_dimVettoreTemp1 && j < l_dimVettoreTemp2) 
    {
        if (l_vettoreTemp1[i] <= l_vettoreTemp2[j]) {
            p_vettore[k] = l_vettoreTemp1[i];
            i++;
        }
        else {
            p_vettore[k] = l_vettoreTemp2[j];
            j++;
        }
        k++;
    }

    // Copio gli elementi rimanenti di  l_vettoreTemp1[], 
    // se ci sono
    while (i < l_dimVettoreTemp1) {
        p_vettore[k] = l_vettoreTemp1[i];
        i++;
        k++;
    }

    // Copio i valori rimanenti di l_vettoreTemo2[], 
    // se ci sono
    while (j < l_dimVettoreTemp2) {
        p_vettore[k] = l_vettoreTemp2[j];
        j++;
        k++;
    }
}

/// Funzione MergeSort
/// Ordina gli elementi all' interno di un vettore
/// @param p_vettore
/// @param p_estrempInf
/// @param p_estremoSup
void mergeSort(vector<int> &p_vettore, int p_estremoInf, int p_estremoSup)
{
	int l_meta;
	
    if (p_estremoInf >= p_estremoSup)
    {
	  return;
    }
    else
    {
	

    	l_meta = p_estremoInf + (p_estremoSup - p_estremoInf) / 2;

    	mergeSort(p_vettore, p_estremoInf, l_meta);

    	mergeSort(p_vettore, l_meta + 1, p_estremoSup);

    	merge(p_vettore, p_estremoInf, l_meta, p_estremoSup);
	}
}

void stampaVettore(vector<int>& arr)
{
    for (int i = 0; i < arr.size(); i++)
        cout << arr[i] << " ";
    cout << endl;
}


int main()
{
    vector<int> arr = { 12, 11, 13, 5, 6, 7 };
    int n = arr.size();

    cout << "Vettore dato: \n";
    stampaVettore(arr);

    mergeSort(arr, 0, n - 1);

    cout << "Vettore ordinato: \n";
    stampaVettore(arr);
    return 0;
}