/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <bits/stdc++.h>

using namespace std;

// Funzione partition
// Partiziona il vettore e restituisce la posizione del pivot
//
// @param p_vettore
// @param p_estremoInf
// @param p_estremoSup
//
// @return j
//
int partition(vector<int> &p_vettore, int p_estremoInf, int p_estremoSup) 
{
    int l_pivot;
	int i,j; 

	l_pivot = p_vettore[p_estremoInf];
	i       = p_estremoInf;
	j       = p_estremoSup;

    while (i < j) 
	{	
        while (p_vettore[i] <= l_pivot && i <= p_estremoSup - 1) 
		{
            i++;
        }

        while (p_vettore[j] > l_pivot && j >= p_estremoInf + 1) 
		{
            j--;
        }
        
        if (i < j)
		{
		  swap(p_vettore[i], p_vettore[j]);
		}
    }
    
    swap(p_vettore[p_estremoInf], p_vettore[j]);
    
    return j;
}

// Funzione qs
// Funzione ricorsiva che esegue il quick sort
//
// @param p_vettore
// @param p_estremoInf
// @param p_estremoSup
//
void qs(vector<int> &p_vettore, int p_estremoInf, int p_estremoSup) 
{
    if (p_estremoInf < p_estremoSup) 
	{
        int l_pIndex;
		
		l_pIndex = partition(p_vettore, p_estremoInf, p_estremoSup);
		
        qs(p_vettore, p_estremoInf, l_pIndex - 1);
        qs(p_vettore, l_pIndex + 1, p_estremoSup);
    }
}

// Funzione quick sort
// Richiama la funzione qs che esegue il quick sort sul vettore
//
// @param p_vettore
//
// @return p_vettore  (ordinato)
//
vector<int> quickSort(vector<int> p_vettore) 
{
    qs(p_vettore, 0, p_vettore.size() - 1);
    
    return p_vettore;
}



int main()
{
	
    vector<int> g_vettore = {4, 6, 2, 5, 7, 9, 1, 3};
    int                 n = g_vettore.size();
    
    cout << "Prima di usare il  quick Sort: " << endl;
    
    //Stampo il vettore a video
    for (int i = 0; i < n; i++)
    {
        cout << g_vettore[i] << " ";
    }
    cout << endl;

	//Applico il quick sort al vettore
    g_vettore = quickSort(g_vettore);
    
    
    cout << "Dopo aver eseguito il  quick sort: " << "\n";
    
    //Stampo il vettore ordinato
    for (int i = 0; i < n; i++) {
        cout << g_vettore[i] << " ";
    }
    cout << "\n";
    return 0;
}
