/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */
 
#include <iostream>
#include <vector>

using namespace std;

/// @brief  ricercaBinaria
/// @brief  Esegue la ricerca binaria in un vettore
/// @param p_vettore 
/// @param p_estremoInferiore 
/// @param p_estremoSuperiore 
/// @param p_valore 
/// @return  la posizione dell' elemento cercato nel vettore
int ricercaBinaria(vector<int> p_vettore, int p_estremoInferiore, int p_estremoSuperiore, int p_valore)
{
    int l_posiozioneMedia;

    // Caso Base dell funzione ricorsiva
    if (p_estremoInferiore>p_estremoSuperiore)
    {
        return -1;
    }

    // Prendo il valore di mezzo del vettore
    l_posiozioneMedia = (p_estremoInferiore+p_estremoSuperiore)/2;

    //Controllo se  il valore che e' a meta' del vettore sia il valore cercato 
    if (p_vettore[l_posiozioneMedia]==p_valore)
    {
        // E' il valore che stavo cercando, restituisco la sua posizione
        return  l_posiozioneMedia;
    }
    else
    {
        // Non e'il valore che stavo cecando, controllo se tale valore sia maggiore del valore cercato
        if (p_vettore[l_posiozioneMedia]>p_valore)
        {
            //Se e' maggiore cerco il numero nella prima meta' del vettore quindi
            //richiamo la funzioe ricercaBinaria sulla prima meta'del vettore
            return ricercaBinaria(p_vettore,p_estremoInferiore,l_posiozioneMedia-1,p_valore);
        }
        else
        {
            //Se e' minore cerco il numero nella seconda meta'del vettore quindi
            // richiamo la fuznione ricercaBinaria sulla seconda meta' del vettore.
            return ricercaBinaria(p_vettore,l_posiozioneMedia+1,p_estremoSuperiore,p_valore);
        }
    }
}

int main(int argc, char** argv)
{
    // Dichiaro il vettore  su cui cercare un valore
    // Per eseguire la ricerca binaria il vettore deve
    // essere ORDINATO in modo crescente.
    vector<int> g_vettore = { 1,3,6,8,9 };

    int g_posizioneElemento;
    int g_valore;

    cout<<"Inserire il valore da ricercare nel vettore: "<<endl;
    cin>>g_valore;

    //Richiamo la funzione ricerca binaria sull'intero vettore
    g_posizioneElemento = ricercaBinaria(g_vettore,0,g_vettore.size(),g_valore);

    if (g_posizioneElemento==-1)
    {
        cout<<"Il valore cercato non e' presente nel vettore.";
    }
    else
    {
        cout<<"Il valore si trova in posizione "<<g_posizioneElemento<<" nel vettore."<<endl;
    }

    return 0;
}

