/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

//Includo la libreria contenente le funzioni di input e output iostream
#include <iostream>

//Includo la libreria per il tipo di dato vector (vettori in c++)
#include <vector>


// Per non dover scrivere il nome della libreria std dove si trovano 
// le funzioni della standard lib definisco il namespace
using namespace std;


//Definisco la funzione di ricerca sequenziale in un vettore

/*
 * int  ricercaSequenziale
 *
 * @param vector<int> p_vettore
 * @param int         p_valore
 *
 * @return int        posizione dell' elemento se presente
 *
 */
 int ricercaSequenziale(vector<int> p_vettore, int p_valore)
 {
 	int l_dimensioneVettore;
 	
 	//Calcolo la dimensione del vettore
 	l_dimensioneVettore = p_vettore.size();
 	
 	//Inizio a ceracare il valore all' interno del vettore
 	for (int i=0; i<l_dimensioneVettore;i++)
 	{
 		if (p_vettore[i]==p_valore)
 		{
		   //Ho trovato l' elemento cercato e restituisco la sua posizione
		   return i; 
		}
	 }
 	
 	//Ho controllato tutto il vettore e non ho trovato l' elemento cercato restituisco -1
 	return -1;
 }


//Funzione principale di un programma C++ dalla quale richiame altre funzioni e/o scrivo il codice del mio programma
int main(int argc, char** argv) {
	
	//Dichiaro le variabili che utilizzero' all'interno del mio codice c++
	
	//Dichiario un vettore di interi e lo inizializzo con dei valori casuali
	vector<int> g_vettore = {3,6,8,1,7};
	
	//Dichiario il valore che voglio cercare nel mio vettore
	int g_valore;
	
	//Dichiario la variabile contenente la posizione dell' elemento  nel vettore
	int g_posizioneElemento;
	
	cout<<"Inserire un valore da cercare nel vettore:"<<endl;
	cin>>g_valore;
	
	//Richiamo la funzione ricercaSequenziale che ho definito precedentemente
	g_posizioneElemento = ricercaSequenziale(g_vettore,g_valore);
	
	
	if (g_posizioneElemento==-1)
	{
		//Non ho trovato l' elemento nel vettore
		cout<<"Il valore "<<g_valore<<" non e' presente nel vettore."<<endl;
	}
	else
	{
		//Ho trovato il valore nel vettore 
		cout<<"Il valore "<<g_valore<<" si trova in posizione "<<g_posizioneElemento<<" nel vettore"<<endl;
	}
	
	system("PAUSE");
	
	return EXIT_SUCCESS;
}

