/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>

using namespace std;

/* Funzione creaMatrice
 * Alloca una matrice di p_righe e p_colonne in memoria
 *
 * @param  p_righe
 * @param  p_colonne
 *
 * @return l_matrice
 */
int** creaMatrice(int p_righe, int p_colonne)
{
	int** l_matrice;
	
	l_matrice = new int*[p_righe];
	
    for (int i = 0; i < p_righe; i++) 
	{
        l_matrice[i] = new int[p_colonne];
	}
	return l_matrice;
}

/* Funzione  inserisciDatiMatrice
 * Inserisce i valori all' interno di una matrice 
 * di p_righe e p_colonne
 *
 * @param p_matrice
 * @param p_righe
 * @param p_colonne
 *
 * @reurn p_matrice
 */
int** inserisciValoriMatrice(int** p_matrice, int p_righe, int p_colonne)
{
	cout<<endl;
	
	// ciclo sulle righe
	for(int i=0;i<p_righe;i++)
	{
	  // ciclo sulle colonne
	  for (int j=0;j<p_colonne;j++)
	  {
	  	cout<<" Inserire il valore dell' elemento a["<<i<<"]["<<j<<"] = ";
	  	cin>>p_matrice[i][j];
	  	
	  }
	  cout<<endl;
	}
	
	return p_matrice;
}

/* Funzione stampaMatrice
 * Stampa a video una matrice di p_righe
 * e p_colonne
 *
 * @param p_matrice
 * @param p_righe
 * @param p_colonne
 *
 */
void stampaMatrice(int** p_matrice, int p_righe, int p_colonne)
{
    for (int i = 0; i < p_righe;i++) 
	{
        for (int j = 0; j < p_colonne;j++) 
		{
          cout <<" " <<p_matrice[i][j];
        }
        cout << endl;
    }
}

int main(int argc, char** argv)
{
	//Definizione dinamica di una matrice
	int** matrice;
	
	// Crea una matrice 3x3
	matrice = creaMatrice(3,3);
	
	
	// Inserisci i valori all'interno della matrice 3x3
	inserisciValoriMatrice(matrice,3,3);
	
	// Stampa a video i valori della matrice 3x3
	stampaMatrice(matrice,3,3);
	
	return EXIT_SUCCESS;
}

