/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>
#include <stdlib.h>

using namespace std;

	//Definizione della struttura Persona
	struct Persona{
		char cognome[50];
		char nome[35];
		char cellulare[11];
	};
	
	
	// Definizione della rubrica
	struct Persona* g_rubrica = NULL;
	
	// Dimensione della rubrica
	int g_dim = 0;
	
	
	/*
	 * Funzione inserisciPersona
	 * Inserisce un Persona nella rubrica
	 *
	 */
	int inserisciPersona()
    {        
		// Incrementa la dimensione della Rubrica
        g_dim++;
        g_rubrica = (Persona*) realloc(g_rubrica, g_dim * sizeof(Persona));
        
        if (g_rubrica == NULL) 
		{
            cout<<"Errore di allocazione della memoria!"<<endl;
            return EXIT_FAILURE;
        }

        // Aggiungi una nuova persona
        cout<<"Inserisci Cognome: ";
    	cin>>g_rubrica[g_dim - 1].cognome;
    	cout<<endl;
    	cout<<"Inserisci Nome: ";
    	cin>>g_rubrica[g_dim - 1].nome;
    	cout<<endl;
    	cout<<"Inserisci il numero di cellulare: ";
    	cin>>g_rubrica[g_dim - 1].cellulare;
    	
    	return EXIT_SUCCESS;
	} 
	
  /*
   * Funzione stampaRubrica
   * Stampa a video i contatti della rubrica
   *
   * @param struct Persona* p_rubrica
   *	
   */
   void stampaRubrica(struct Persona* p_rubrica)
   {
   	 // Visualizza tutte le persone
   	  cout<<endl;
      cout<<"Elenco delle persone: "<<endl;
      
      for (int i = 0; i < g_dim; i++) 
	  {
         cout<<"Cognome: "   << p_rubrica[i].cognome
		    <<"  Nome: "     << p_rubrica[i].nome
			<<" Cellulare: " << p_rubrica[i].cellulare
			<<endl;
      }
   }
	 
	int main(int argc, char** argv)
	{		
		 int scelta;

    do {
    	cout<<endl;
        cout<<"Menu:"<<endl;
        cout<<"1. Aggiungi persona"<<endl;
        cout<<"2. Visualizza persone"<<endl;
        cout<<"3. Esci"<<endl;
        cout<<"Scelta: ";
        cin>>scelta;

        switch (scelta) {
        	
            case 1: {
                // Aggiunge contatto in rubrica
                inserisciPersona();
                break;
            }
            
            case 2: {
                // Visualizza tutte le persone
                stampaRubrica(g_rubrica);
                break;
            }
            
            case 3:
                cout<<"Uscita dal programma."<<endl;
                break;
                
            default:
                cout<<"Scelta non valida!"<<endl;
        }
        
    } while (scelta != 3);

    // Libera la memoria allocata
    free(g_rubrica);
    
	 return EXIT_SUCCESS;
	}