/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>

using namespace std;

// Definizione della struttura point
struct point{
	double x;
	double y;
	char   label;
};

// Dichiarazione di variabile di tipo point
struct point g_punto;


/* Funzione creaPunto
 * Date le coordinate x,y e il nome di un punto
 * restituisce una variabile di tipo point
 *
 * @param double p_x
 * @param double p_y
 * @param char   p_nome
 *
 * @return struct point l_punto
 *
 */
 struct point creaPunto(double p_x, double p_y, 
                        char p_nome)
 {
 	struct point l_punto;
 	
 	l_punto.x     = p_x;
 	l_punto.y     = p_y;
 	l_punto.label = p_nome;
 	
 	return l_punto;
 }

/* Funzione stampaPunto
 *
 * stampa a video un punto 
 *
 * @param struct point p_punto
 *
 */
 void stampaPunto(struct point p_punto)
 {
 	cout<<" "<<p_punto.label<<"("<<p_punto.x<<","<<p_punto.y<< ")"<<endl;
 }

int main(int argc, char** argv) {

	// Chiamata della funzione creaPunto
	g_punto = creaPunto(6,5,'A');

	// Chiamata della funzione stampaPunto
	stampaPunto(g_punto);

	return EXIT_SUCCESS;
}