/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#ifndef __CALCOLATRICE_H__
#define __CALCOLATRICE_H__

#include <iostream>

 /*
  * Funzione che calcola l'addizione tra due numeri reali
  *
  * @param  double p_addendoUno
  *
  * @param  double p_addendoDue
  *
  * @return double l_risultato
  *
  */
double addizione(double p_addendoUno, double p_addendoDue);

 /*
  * Funzione che calcola la sottrazione tra due numeri reali
  *
  * @param  double p_mineundo
  *
  * @param  double p_sottraendo 
  *
  * @return double l_risultato
  *
  */
double sottrazione(double p_minuendo, double p_sottraendo);

 /*
  * Funzione che calcola la moltiplicazione tra due numeri reali
  *
  * @param  double p_fattoreUno
  *
  * @param  double p_fattoreDue
  *
  * @return double l_risultato 
  *
  */
double moltiplicazione(double p_fattoreUno, double p_fattoreDue);

 /*
  * Funzione che calcola la divisione tra due numeri reali
  *
  * @param  double p_numeratore
  *
  * @param  double p_denominatore
  *
  * @return double l_risultato
  *
  */
double divisione(double p_numeratore, double p_denominatore);

#endif //__CALCOLATRICE_H__