/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "codaCircolare.h"

// Crea la coda circolare
CodaCircolare* creaCoda(){
	
	try
	{
		CodaCircolare* l_nuovaCoda = (CodaCircolare*)malloc(sizeof(CodaCircolare));
		
		if (l_nuovaCoda == NULL)
		{
			throw runtime_error("Errore di allocazione della memoria.");
		}
		
    	l_nuovaCoda->testa = -1;
    	l_nuovaCoda->coda  = -1;
    	
    	return l_nuovaCoda;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return NULL;
	}
   
}

// Controlla se la coda è piena
bool isFull(CodaCircolare* p_coda) {
	
	if ( (p_coda->testa == 0 && p_coda->coda == SIZE - 1) || 
	     (p_coda->coda == (p_coda->testa - 1) % (SIZE - 1)) )
	{
		return true;
	}
	
    return false;
}

// Controlla se la coda è vuota
bool isEmpty(CodaCircolare* p_coda) {
	
	if (p_coda->testa == -1)
	{
		return true;
	}
	
    return false;
}

// Inserisce un elemento nella coda
void inCoda(CodaCircolare *p_coda, int p_valore){
	
    if (isFull(p_coda)) 
	{	
        cout<<"Coda piena! Impossibile inserire il valore "
		    <<p_valore<<endl;
        return;
    }
    
    if (isEmpty(p_coda)) 
	{
        p_coda->testa = 0;
		p_coda->coda  = 0;
		
    } 
	else
	{
		if (p_coda->testa == SIZE - 1 && p_coda->testa != 0) 
		{	
        	p_coda->testa = 0; // Torna all'inizio dell'array
        		
    	} 
		else 
		{
        	p_coda->coda++;
    	}
	}
	
    p_coda->valori[p_coda->coda] = p_valore;
}


// Estrae un elemento dalla coda
int estrai(CodaCircolare *p_coda) {
	
	int l_valore;
	
    if (isEmpty(p_coda)) 
	{
        cout<<"Coda vuota! Nessun elemento da estrarre."<<endl;
        return EXIT_FAILURE;
    }
    
    l_valore = p_coda->valori[p_coda->testa];
    
    if (p_coda->testa == p_coda->coda) 
	{
    	p_coda->testa = p_coda->coda = -1; // La coda è ora vuota
    } 
	else 
	{
		if (p_coda->testa == SIZE - 1)
		 {
        	p_coda->testa = 0; // Torna all'inizio dell'array
    	 }
		 else 
		{
        	p_coda->testa++;
   		 }
   	}
   	
    return l_valore;
}

// Funzione per visualizzare l' elemento in testa alla coda
int peek(CodaCircolare* p_coda) 
{
	int   l_valore;
	
	try
	{
		if (p_coda->testa == -1) 
		{
			throw runtime_error("Errore la coda e' vuota.");	
		}
		
    	l_valore  = p_coda->valori[p_coda->testa];
    	
    	return l_valore;		
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
       	return EXIT_FAILURE;
	}
    
}


// Stampa gli elementi della coda
void stampaCoda(CodaCircolare* p_coda) {
	
    if (isEmpty(p_coda)) 
	{
        cout<<"Coda vuota!"<<endl;
        return;
    }
    
    cout<<"Elementi nella coda: ";
    
    if (p_coda->coda >= p_coda->testa) 
	{
        for (int i = p_coda->testa; i <= p_coda->coda; i++) 
		{
        	cout<<p_coda->valori[i]<<" ";
        }
    } 
	else 
	{
        for (int i = p_coda->testa; i < SIZE; i++)
		 {
            cout<<p_coda->valori[i]<<" ";
        }
        
        for (int i = 0; i <= p_coda->coda; i++)
		{
        	cout<<p_coda->valori[i]<<" ";
        }
    }
    
    cout<<endl;
}
