/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#ifndef __CODA_CIRCOLARE_H__
#define __CODA_CIRCOLARE_H__

#include <iostream>
#include <stdlib.h>
#include <stdexcept>

using namespace std;


// Definizione della dimensione della coda circolare
#define SIZE 8

// Definizione della coda circolare
typedef struct {
    int valori[SIZE];
    int testa;
	int coda;
} CodaCircolare;

/*
 * Funzione creaCoda
 * Crea la coda vuota
 *
 * @param CodaCircolare* p_coda
 */
CodaCircolare* creaCoda();

/*
 * Funzione isFull
 * Controlla se la coda e' piena
 *
 * @param CodaCircolare* p_coda
 *
 * @return true/false
 */
bool isFull(CodaCircolare* p_coda);

/*
 * Funzione isEmpty
 * Controlla se la coda e' vuota
 *
 * @param CodaCircolare* p_coda
 *
 * @return true/false
 */
bool isEmpty(CodaCircolare* p_coda);

/*
 * Funzione inserisciInCoda
 * Inserisce un elemento nella coda
 *
 * @param CodaCircolare* p_coda
 * @param int            p_valore
 */
void inCoda(CodaCircolare *p_coda, int p_valore);

/*
 * Funzione estrai
 * Estre un elemento dalla coda
 *
 * @param CodaCircolare* p_coda
 *
 * @return int  l_valore
 */
int estrai(CodaCircolare *p_coda);

/*
 * Funzione peek
 * Restituisce il valore in testa dalla coda senza rimuoverlo
 *
 * @param CodaCircolare* p_coda
 *
 * @return int  l_valore
 */
int peek(CodaCircolare* p_coda);


/*
 * Funzione stampaCoda
 * Stampa a video la coda
 *
 * @param CodaCircolare* p_coda
 */
void stampaCoda(CodaCircolare* p_coda);

#endif //__CODA_CIRCOLARE_H__