/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "deque.h"

// Crea un nuvo nodo della lista
Nodo* creaNodo(int p_valore)
{
	try
	{
		Nodo* l_nuovoNodo = (Nodo*)malloc(sizeof(Nodo));
		
		 if (l_nuovoNodo == NULL) 
		 {
		 	throw runtime_error("Errore di allocazione della memoria.");
		 }
		 
		l_nuovoNodo->dato = p_valore;
		l_nuovoNodo->prev = NULL;
    	l_nuovoNodo->next = NULL;
    	
    	return l_nuovoNodo;
	
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return NULL;
	}

}

// Inizializza la coda doppia
Deque* creaDeque() 
{	
	try{
		Deque* l_deque = (Deque*)malloc(sizeof(Deque));
		
		if (l_deque == NULL) 
		{
		 	throw runtime_error("Errore di allocazione della memoria.");
		}
		
    	l_deque->testa = NULL;
    	l_deque->coda  = NULL;
 		
		return l_deque;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return NULL;
	}
    
}

// Inserisce un elemento all'inizio
void pushFront(Deque* p_deque, int p_valore) 
{
	Nodo* l_nuovoNodo;
	
    l_nuovoNodo = creaNodo(p_valore);
    
    if (p_deque->testa == NULL) 
	{   // La coda e' vuota
        p_deque->testa = l_nuovoNodo; 
		p_deque->coda  = l_nuovoNodo;
    } 
	else 
	{
        l_nuovoNodo->next    = p_deque->testa;
        p_deque->testa->prev = l_nuovoNodo;
        p_deque->testa       = l_nuovoNodo;
    }
}

// Inserisce un elemento alla fine
void pushBack(Deque* p_deque, int p_valore) 
{
    Nodo* l_nuovoNodo;
    
	l_nuovoNodo = creaNodo(p_valore);
    
    if (p_deque->coda == NULL) 
	{  // La coda e' vuota
        p_deque->testa = l_nuovoNodo;
		p_deque->coda  = l_nuovoNodo;
    } 
	else 
	{
        l_nuovoNodo->prev   = p_deque->coda;
        p_deque->coda->next = l_nuovoNodo; 
        p_deque->coda       = l_nuovoNodo;
    }
}

// Rimuove un elemento dall'inizio
int popFront(Deque* p_deque) 
{
	try
	{
		if (p_deque->testa == NULL) 
		{
			throw runtime_error("Errore la coda e' vuota.");
		}
		
		Nodo* l_temp = p_deque->testa;
    	int   l_dato = l_temp->dato;
    	
    	p_deque->testa = p_deque->testa->next;
    	
    	if (p_deque->testa != NULL) 
		{
        	p_deque->testa->prev = NULL;
    	}
		else 
		{
        	p_deque->coda = NULL;
    	}
			
    	free(l_temp);
    	
    	return l_dato;
		
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
       	return EXIT_FAILURE;
	}
}

// Rimuove un elemento dalla fine
int popBack(Deque* p_deque) 
{
	try{
		if (p_deque->coda == NULL) 
		{
			throw runtime_error("Errore la coda e' vuota.");
		}
		
		Nodo* l_temp = p_deque->coda;
    	int   l_dato= l_temp->dato;
    	
    	p_deque->coda = p_deque->coda->prev;
    	
    	if (p_deque->coda != NULL)
		{
        	p_deque->coda->next = NULL;
    	}
		else
		{
        	p_deque->testa = NULL;
    	}
    	
    	free(l_temp);
    	
    	return l_dato;
	
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
       	return EXIT_FAILURE;
	
	}
    
}

// Visualizza il primo elemento senza rimuoverlo
int peekFirst(Deque* p_deque)
 {
 	try{
 		
 		if (p_deque->testa == NULL) 
		{
			throw runtime_error("Errore la coda e' vuota.");
		}
	
 		return p_deque->testa->dato;	
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
       	return EXIT_FAILURE;
	
	}
}

// Visualizza l'ultimo elemento senza rimuoverlo
int peekLast(Deque* p_deque) 
{
	try{
		
		 if (p_deque->coda == NULL) 
		 {
		 	throw runtime_error("Errore la coda e' vuota.");
		 }
		 
		 return p_deque->coda->dato;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
       	return EXIT_FAILURE;
	
	}
}

// Funzione per stampare la coda
void printDeque(Deque* p_deque) 
{
    Nodo* l_current = p_deque->testa;
    
    cout<<"Coda: ";
    
    while (l_current != NULL)
	 {
        cout<<l_current->dato<<" ";
        l_current = l_current->next;
    }
    
    cout<<endl;
}

// Funzione per rimuovere tutta la coda dalla memoria
void freeDeque(Deque* p_deque) 
{
    Nodo* l_corrente = p_deque->testa;
    
    while (l_corrente != NULL) 
	{
        Nodo* l_temp = l_corrente;
        
        l_corrente = l_corrente->next;
        free(l_temp);
    }
    
    free(p_deque);
}