/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#ifndef __DEQUE_H__
#define __DEQUE_H__

#include <iostream>
#include <stdlib.h>
#include <stdexcept>

using namespace std;

// Nodo della lista concatenata doppia
typedef struct Nodo {
    int 		 dato;
    struct Nodo* prev;
    struct Nodo* next;
} Nodo;

// Struttura della coda doppia
typedef struct Deque {
    Nodo* testa;
    Nodo* coda;
} Deque;

/*
 * Funzione creaNodo
 * Crea un nodo della lista
 *
 * @param int p_valore
 *
 * @return Nodo* l_nuovoNodo
 */
Nodo* creaNodo(int p_valore);

/*
 * Funzione creaDeque
 * Crea la coda
 *
 * @return Deque* l_deque
 */
Deque* creaDeque();

/*
 * Funzione pushFront
 * Inserice un elemento in testa
 *
 * @param Deque* p_deque
 * @param int    p_valore
 */
void pushFront(Deque* p_deque, int p_valore);

/*
 * Funzione pushBack
 * Inserice un elemento in coda
 *
 * @param Deque* p_deque
 * @param int    p_valore
 */
void pushBack(Deque* p_deque, int p_valore);

/*
 * Funzione popFront
 * Restituisce e rimuove l'elemento in testa
 *
 * @param Deque* p_deque
 *
 * @return int   p_valore
 */
int popFront(Deque* p_deque);

/*
 * Funzione popBack
 * Restituisce e rimuove l'elemento in coda
 *
 * @param Deque* p_deque
 *
 * @return int   p_valore
 */
int popBack(Deque* p_deque);

/*
 * Funzione peekFirst
 * Restituisce l'elemento in testa alla coda 
 * senza rimuoverlo
 *
 * @param Deque* p_deque
 *
 * @return int   p_valore
 */
int peekFirst(Deque* p_deque);

/*
 * Funzione peekLast
 * Restituisce l'elemento alla fine della coda 
 * senza rimuoverlo
 *
 * @param Deque* p_deque
 *
 * @return int   p_valore
 */
int peekLast(Deque* p_deque);

/*
 * Funzione printDeque
 * Stampa gli elementi della coda
 *
 * @param Deque* p_coda
 */
void printDeque(Deque* p_deque);

/*
 * Funzione freeDeque
 * Rimuove dalla memoria la coda
 *
 * @param Deque* p_deque
 */
void freeDeque(Deque* p_deque);

#endif // __DEQUE_H__