/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>
#include "deque.h"

using namespace std;

int main(int argc, char** argv){
	
	int    l_scelta;
	int    l_valore;
    Deque* l_deque;  
   
   l_deque = creaDeque();
   
	do {
    	cout<<endl;
        cout<<"Menu:"<<endl;
        cout<<"1. Inserisci elemento in testa"<<endl;
        cout<<"2. Inserisci elemento in coda"<<endl;
        cout<<"3. Estrai l' elemento in testa"<<endl;
        cout<<"4. Estrai l' elemento in coda"<<endl;
        cout<<"5. Visualizza elemento in testa"<<endl;
        cout<<"6. Visualizza elemento in coda"<<endl;
        cout<<"7. Stampa la Coda"<<endl;;
        cout<<"8. Esci"<<endl;
        cout<<"Scelta: ";
        cin>>l_scelta;

        switch (l_scelta) {
        	
            case 1: {
                // Aggiunge un elemnto nella Coda
                cout<<"Inserire il valore da aggiungere in testa alla coda: ";
                cin>>l_valore;
                cout<<endl;
                pushFront(l_deque,l_valore);
                break;
            }
            
            case 2: {
             	 // Aggiunge un elemnto alla fine della Coda
                cout<<"Inserire il valore da aggiungere alla fine della coda: ";
                cin>>l_valore;
                cout<<endl;
                pushBack(l_deque,l_valore);
                break;
            }
            
            case 3: {
                // Estrai l'elemnto in testa 
                l_valore = popFront(l_deque);
                cout<<"Valore estratto : "<<l_valore;
                cout<<endl;
                break;
            }
            
            case 4: {
                // Estrai l'elemnto in coda
                l_valore = popBack(l_deque);
                cout<<"Valore estratto : "<<l_valore;
                cout<<endl;
                break;
            }
            
            case 5: {
                // Visualizza l' elemnto in testa alla coda
                 l_valore = peekFirst(l_deque);
                cout<<"Valore in cima alla coda e' : "<<l_valore;
                cout<<endl;
                break;
            }
            
            case 6: {
                // Visualizza l' elemnto in coda
                 l_valore = peekLast(l_deque);
                cout<<"Valore in fondo alla coda e' : "<<l_valore;
                cout<<endl;
                break;
            }
            
            case 7: {
                // Visualizza i valori della coda
                printDeque(l_deque);
                break;
            }
            
			case 8: {
				cout<<"Uscita dal programma."<<endl;
				freeDeque(l_deque);
				free(l_deque);
                break;
			}
                
            default:
                cout<<"Scelta non valida!"<<endl;
        }
        
    } while (l_scelta != 8);

					
	return EXIT_SUCCESS;	
}
