/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "coda.h"

// Crea un nuvo nodo della lista
Nodo* creaNodo(int p_valore)
{
	try
	{
		Nodo* l_nuovoNodo = (Nodo*)malloc(sizeof(Nodo));
		
		 if (l_nuovoNodo == NULL) 
		 {
		 	throw runtime_error("Errore di allocazione della memoria.");
		 }
		 
		l_nuovoNodo->dato = p_valore;
    	l_nuovoNodo->next   = NULL;
    	
    	return l_nuovoNodo;
	
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return NULL;
	}

}


// Funzione per creare una nuova coda
Coda* creaCoda() 
{
	try
	{
		Coda* l_nuovaCoda = (Coda*)malloc(sizeof(Coda));
		
		if (l_nuovaCoda == NULL)
		{
			throw runtime_error("Errore di allocazione della memoria.");
		}
		
    	l_nuovaCoda->testa = NULL;
    	l_nuovaCoda->coda = NULL;
    	
    	return l_nuovaCoda;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return NULL;
	}
   
}

// Funzione per aggiungere un elemento alla coda (enqueue)
void inCoda(Coda* p_coda, int p_valore) 
{
    Nodo* l_nuovoNodo = creaNodo(p_valore);

    if (p_coda->coda == NULL) 
	{   // Se la coda e' vuota
        p_coda->testa = l_nuovoNodo;
        p_coda->coda  = l_nuovoNodo;
    } 
	else 
	{
        p_coda->coda->next = l_nuovoNodo;
        p_coda->coda       = l_nuovoNodo;
    }
}

// Funzione per rimuovere un elemento dalla coda (dequeue)
int estraiInTesta(Coda* p_coda) 
{
	Nodo* l_nodoDaRimuovere = NULL;
	int   l_valore;
	
	try
	{
		if (p_coda->testa == NULL) 
		{
			throw runtime_error("Errore la coda e' vuota.");	
		}
		
		l_nodoDaRimuovere = p_coda->testa;
    	l_valore          = l_nodoDaRimuovere->dato;
    	p_coda->testa     = p_coda->testa->next;

    	if (p_coda->testa == NULL) 
		{ 	
		 	// Se sto estraendo  l'ultimo elemento la coda diventa vuota
        	p_coda->coda = NULL;
    	}

    	free(l_nodoDaRimuovere);
    	
    	return l_valore;		
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
       	return EXIT_FAILURE;
	}
    
}

// Funzione per visualizzare l' elemento in testa alla coda
int peek(Coda* p_coda) 
{
	Nodo* l_nodo = NULL;
	int   l_valore;
	
	try
	{
		if (p_coda->testa == NULL) 
		{
			throw runtime_error("Errore la coda e' vuota.");	
		}
		
		l_nodo    = p_coda->testa;
    	l_valore  = l_nodo->dato;
    	
    	return l_valore;		
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
       	return EXIT_FAILURE;
	}
    
}

// Funzione per verificare se la coda è vuota
int isEmpty(Coda* p_coda) 
{
	if (p_coda->testa == NULL)
	{
		return true;
	}
    return false;
}

// Stampa a video la coda
void stampaCoda(Coda* p_coda) 
{
    Nodo* l_corrente = p_coda->testa;
    
    cout<<"Testa -> ";
    
    while (l_corrente != NULL) 
	{
		cout<<l_corrente->dato<<"  ";
        l_corrente = l_corrente->next;
    }
    
    cout<<" <- Coda"<<endl;
}

// Funzione per cancellare dalla memoria la coda
void rimuoviCoda(Coda* p_coda) 
{
    while (!isEmpty(p_coda)) 
	{
        estraiInTesta(p_coda);
    }
    
    free(p_coda);
}
