/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#ifndef __CODA_H__
#define  __CODA_H__

#include <iostream>
#include <stdlib.h>
#include <stdexcept>

using namespace std;

// Definizione del nodo della lista
typedef struct Nodo {
    int dato;
    struct Nodo* next;
} Nodo;

// Definizione della coda
typedef struct Coda {
    Nodo* testa;
    Nodo* coda;
} Coda;

/*
 * Crea un nuovo elemento da
 * inserire nella lista
 *
 * @param int p_valore
 *
 * @return Nodo* l_nuovoElemento
 */
Nodo* creaNodo(int p_valore);

/*
 * Funzione creaCoda
 * Crea una coda vuota
 *
 * @return  Coda* l_nuovaCoda 
 */
Coda* creaCoda();

/*
 * Fuzione inCoda
 * Inserisce un valore in fondo alla coda
 *
 * @param Coda* p_coda
 * @param int   p_valore
 */
void inCoda(Coda* p_coda, int p_valore);

/*
 * Funzione estraiInTesta
 * Restituisce e rimuove l'elemento in testa alla coda
 *
 * @param Coda* p_coda
 *
 * @return int  l_valore
 */
int estraiInTesta(Coda* p_coda);

/*
 * Funzione peek
 * Restituisce il valore in testa dalla coda senza rimuoverlo
 *
 * @param Coda* p_coda
 *
 * @return int  l_valore
 */
int peek(Coda* p_coda);

/*
 * Funzione isEmpty
 * Controlla se la coda e' vuota
 *
 * @param Coda* p_coda
 *
 * @return  true/false
 */
int isEmpty(Coda* p_coda);

/*
 * Funzione stampaCoda
 * Stampa a video la coda
 *
 * @param Coda* p_coda
 */
void stampaCoda(Coda* p_coda);

/*
 * Funzione rimuoviCoda
 * Cancella la coda dalla memoria
 *
 * @param Coda* p_coda
 */
void rimuoviCoda(Coda* p_coda);

#endif // __CODA_H__