/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "codaPriorita.h"

// Crea un nuvo nodo della lista
Nodo* creaNodo(int p_valore, int p_priorita)
{
	try
	{
		Nodo* l_nuovoNodo = (Nodo*)malloc(sizeof(Nodo));
		
		 if (l_nuovoNodo == NULL) 
		 {
		 	throw runtime_error("Errore di allocazione della memoria.");
		 }
		 
		l_nuovoNodo->dato 	  = p_valore;
		l_nuovoNodo->priorita = p_priorita;
    	l_nuovoNodo->next     = NULL;
    	
    	return l_nuovoNodo;
	
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return NULL;
	}

}

// Crea la coda a priorita'
Queue* creaQueue() 
{	
	try{
		Queue* l_queue = (Queue*)malloc(sizeof(Queue));
		
		if (l_queue == NULL) 
		{
		 	throw runtime_error("Errore di allocazione della memoria.");
		}
		
    	l_queue->testa = NULL;
 		
		return l_queue;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return NULL;
	}
    
}

// Controlla se la coda e' vuota
bool isEmpty(Queue* p_queue) 
{
	if (p_queue->testa == NULL)
	{
		return true;
	}
	
    return false;
}

// Inserisce un elemento ordinato per priorita'
int push(Queue* p_queue, int p_dato, int p_priorita) 
{
	try{
		
		Nodo* l_nuovoNodo = creaNodo(p_dato, p_priorita);
		
		if (l_nuovoNodo == NULL)
		{
			throw runtime_error("Errore di allocazione della memoria.");
		} 
		
		if (p_queue->testa == NULL || 
			p_priorita > p_queue->testa->priorita)
			{
        	 	l_nuovoNodo->next = p_queue->testa;
        		p_queue->testa    = l_nuovoNodo;
    		}
		else 
			{
        	  Nodo* l_current = p_queue->testa;
        	  while (l_current->next != NULL && 
			         l_current->next->priorita >= p_priorita)
					{
            			l_current = l_current->next;
        			}
        			
        	  l_nuovoNodo->next = l_current->next;
        	  l_current->next   = l_nuovoNodo;
    		}   
    	return EXIT_SUCCESS; // Successo	
		
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return EXIT_FAILURE;
	}
}

// Rimuove l'elemento con priorita' piu' alta
int pop(Queue* p_queue) 
{
	try
	{
		if (isEmpty(p_queue))
		{
			throw runtime_error("Errore: coda vuota, impossibile rimuovere");
		}
		
		Nodo* l_temp;   
		int   l_valore;
		
		l_temp   =  p_queue->testa;
		l_valore =  l_temp->dato;
    	p_queue->testa = p_queue->testa->next;
    	
		free(l_temp);
		
    	return l_valore;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return EXIT_FAILURE;
	}
}

// Restituisce il primo elemento della coda senza rimuoverlo
int peek(Queue* p_queue){
	try
	{
		if (isEmpty(p_queue))
		{
			throw runtime_error("Errore: coda vuota");
		}
		
		Nodo* l_temp;   
		int   l_valore;
		
		l_temp   =  p_queue->testa;
		l_valore =  l_temp->dato;
		
    	return l_valore;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return EXIT_FAILURE;
	}
}

// Visualizza la coda
int printQueue(Queue* p_queue)
 {
 	try{
	 
 		if (isEmpty(p_queue))
		{
			throw runtime_error("Coda vuota");
		}
		
		Nodo* l_current = p_queue->testa;
		
    	while (l_current != NULL) 
		{
        	cout<<"Dato: "<<l_current->dato<<" | Priorita': "
			    <<l_current->priorita<<endl;
        	l_current = l_current->next;
    	}	
    	
		return EXIT_SUCCESS;		
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return EXIT_FAILURE;
	}
}

// Rimuove dalla memoria la coda
int clearQueue(Queue* p_queue)
 {
 	try
	{
 		if (isEmpty(p_queue))
		{
			throw runtime_error("Errore: coda vuota, impossibile rimuovere");
		}
		
		Nodo* l_current = p_queue->testa;
		
    	while (l_current != NULL) {
        	Nodo*  l_temp = l_current;
        	l_current = l_current->next;
        	free(l_temp);
    	}
    	
    	p_queue->testa = NULL;	
    	free(p_queue);
    	
    	return EXIT_SUCCESS;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return EXIT_FAILURE;
	}
}
