/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#ifndef __CODA_PRIORITA_H__
#define __CODA_PRIORITA_H__

#include <iostream>
#include <stdlib.h>
#include <stdexcept>

using namespace std;

// Nodo della coda con priorita'
typedef struct Nodo {
    int dato;
    int priorita;
    struct Nodo* next;
} Nodo;

// Struttura della coda prioritaria
typedef struct Queue {
    Nodo* testa;
} Queue;

/*
 * Funzione creaNodo
 * Crea un nuovo nodo da inserire nella coda
 *
 * @param  int   p_valore
 * @param  int   p_priorita
 *
 * @return Nodo* l_nuovoNodo
 */
Nodo* creaNodo(int p_valore, int p_priorita);

/*
 * Funzione creaQueue
 * Crea la coda a priorita'
 *
 * @return Queue* l_queue
 */
Queue* creaQueue();

/*
 * Funzione isEmpty
 * Controlla se la coda e' vuota
 *
 * @param Queue* p_queue
 *
 * @return true/false
 */
bool isEmpty(Queue* p_queue); 

/*
 * Funzione push
 * Inserisce un elemento ordinato per priorita'
 *
 * @param Queue* p_queue
 * @param int    p_dato
 * @param int    p_priorita
 *
 * @return EXIT_SUCCESS/EXIT_FAILURE
 */
int push(Queue* p_queue, int p_dato, int p_priorita);

/*
 * Funzione pop
 * Rimuove l'elemento con priorita' piu' alta
 *
 * @param Queue* p_queue)
 *
 * @return l_valore
 */
int pop(Queue* p_queue);

/*
 * Funzione PEEK
 * Restituisce l'elemento che verrebbe rimosso
 * con il comando POP senza rimuoverlo dalla coda
 *
 * @param Queue* p_queue
 *
 * @return int l_valore
 */
int peek(Queue* p_queue);

/*
 * Funzione printQueue
 * Visualizza la coda
 *
 * @param Queue* p_queue
 *
 * @return EXIT_SUCCESS/EXIT_FAILURE
 */
int printQueue(Queue* p_queue);

/*
 * Funzione clearQueue
 * Cancella dalla memoria la coda
 *
 * @param Queue* p_queue
 */
int clearQueue(Queue* p_queue);

#endif // __CODA_PRIORITA_H__