/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>
#include "codaPriorita.h"

int main(int argc, char** argv){
	
	int    l_scelta;
	int    l_valore;
	int    l_priorita;
    Queue* l_coda;  
   
   	l_coda = creaQueue();
   
	do {
    	cout<<endl;
        cout<<"Menu:"<<endl;
        cout<<"1. Inserisci elemento"<<endl;
        cout<<"2. Estrai un  elemento"<<endl;
        cout<<"3. Visualizza elemento in testa"<<endl;
        cout<<"4. Stampa la Coda"<<endl;;
        cout<<"5. Esci"<<endl;
        cout<<"Scelta: ";
        cin>>l_scelta;

        switch (l_scelta) {
        	
            case 1: {
                // Aggiunge un elemento nella Pila
                cout<<"Inserire il valore da aggiungere alla coda: ";
                cin>>l_valore;
                cout<<endl;
                cout<<"Inserire il valore della sua priorita' : ";
                cin>>l_priorita;
                cout<<endl;
                push(l_coda,l_valore,l_priorita);
                break;
            }
            
            case 2: {
                // Estrai l'elemento dalla Coda con priorita' piu' alta
                l_valore = pop(l_coda);
                cout<<"Valore estratto : "<<l_valore;
                cout<<endl;
                break;
            }
            
            case 3: {
                // Visualizza l' elemnto in testa alla coda
                 l_valore = peek(l_coda);
                cout<<"Valore in testa alla coda e' : "<<l_valore;
                cout<<endl;
                break;
            }
            
            case 4: {
                // Visualizza i valori della lista
                printQueue(l_coda);
                break;
            }
            
            case 5: {
				cout<<"Uscita dal programma."<<endl;
				clearQueue(l_coda);
                break;
			}
            
                
            default:
                cout<<"Scelta non valida!"<<endl;
        }
        
    } while (l_scelta != 5);

					
	return EXIT_SUCCESS;
	
	
}


/*



int main(int argc, char** argv) {
	
    Queue* miaCoda = creaQueue();
    if (miaCoda == NULL) {
        return 1; // uscita con errore
    }

    push(miaCoda, 10, 2);
    push(miaCoda, 20, 5);
    push(miaCoda, 30, 3);

    printQueue(miaCoda);

    pop(miaCoda);
    printQueue(miaCoda);

    clearQueue(miaCoda);
   // free(miaCoda); // libera la struttura stessa

    return 0;
}

*/