#ifndef    __GRAFO_H__
#define    __GRAFO_H__

#include <List>

// Definizione del Nodo del Grafo
typedef struct Nodo {
    int    id;    //Etichetta con cui si identifica il nodo
    double value; //Valore che si puo' associare al nodo tipico dei problemi di flusso
} Nodo;

// Definizione di Arco del Grafo
typedef struct Archi {
	int    nodoStart;  // Testa dell'arco
	int    nodoEnd;    // Coda dell'arco
	double cost;       // Eventuale costo
	double minFlow;    // Flusso minimo dell'arco
	double flow;       // Flusso nell'arco
	double maxFlow;    // Flusso massimo dell'arco
	bool   oriented;   // Flag che indica se e' orientato oppure no
}Archi;

// Definizione della struttura ListaNodi
typedef struct ListaNodi{
	Nodo        nodo;
	list<Archi> stellaEntrante;
	list<Archi> stellaUscente;
}ListaNodi;

// Definizione della struttura ListaDiAdiacenza
typedef struct ListaDiAdiacenza{
	int              numeroNodi;
	int              numeroArchi;
	list<ListaNodi>  nodi;
	list<Archi>      archi;
}ListaDiAdiacenza;

// Definizione di Grafo
ListaDiAdiacenza* Grafo;

#endif //  __GRAFO_H__