/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "lista.h"

Lista* creaLista() 
{  
	try
	{
    	Lista* l_lista = (Lista*)malloc(sizeof(Lista));
    	
    	if (l_lista==NULL)
    	{
    		throw runtime_error("Errore di allocazione della memoria.");
		}
    	
		l_lista->testa = NULL;
    	l_lista->coda = NULL;
    	
		return l_lista;
    } 
    catch(const exception& e)
    {
	  cerr<<"Eccezione catturata: "<<e.what()<<endl;
	  return NULL;
	}
}


bool listaVuota(Lista* p_lista) 
{
	if(p_lista->testa == NULL)
	{
		return true;
	}
	
    return false;
}

Nodo* creaNodo(int p_valore)
{
	try
	{
		Nodo* l_nuovoNodo = (Nodo*)malloc(sizeof(Nodo));
		
		 if (l_nuovoNodo == NULL) 
		 {
		 	throw runtime_error("Errore di allocazione della memoria.");
		 }
		 
		l_nuovoNodo->valore = p_valore;
    	l_nuovoNodo->next   = NULL;
    	
    	return l_nuovoNodo;
	
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return NULL;
	}

}


void aggiungiNodoInTesta(Lista* p_lista, int p_valore) 
{
    Nodo* l_nuovoNodo     = creaNodo(p_valore);
    
    l_nuovoNodo->next     = p_lista->testa;

    p_lista->testa        = l_nuovoNodo;
    
    if (listaVuota(p_lista))
    {   
	    // Se la lista era vuota
        p_lista->coda = l_nuovoNodo;
    }
}


void aggiungiNodoInCoda(Lista* p_lista, int p_valore) 
{
    Nodo* l_nuovoNodo     = creaNodo(p_valore);
    

    if (p_lista->coda != NULL) 
	{
        p_lista->coda->next = l_nuovoNodo;
    }
    
    p_lista->coda = l_nuovoNodo;

    if (listaVuota(p_lista)) 
	{
	    // Se la lista era vuota
        p_lista->testa = l_nuovoNodo;
    }
}


void cancellaNodoInTesta(Lista* p_lista) 
{
    
	if (listaVuota(p_lista)) 
	{
     return;	
	}
	
	// Puntatore alla testa per eliminare il dato
    Nodo* temp = p_lista->testa;
    
    // Sposto il puntatore alla testa di uno
    p_lista->testa = p_lista->testa->next;
    
    // Se non ci sono elementi la lista diventa vuota
    if (p_lista->testa == NULL) 
	{
    	p_lista->coda = NULL;
    }
    
    // Elimino il dato che era in testa
    free(temp);
}


void cancellaNodoInCoda(Lista* p_lista)
{
	// Lista vuota
    if (listaVuota(p_lista))
	{
	  return;
	}
	
	// Lista con un solo elemento
    if (p_lista->testa == p_lista->coda) 
	{
        free(p_lista->testa);
        p_lista->testa = p_lista->coda = NULL;
        return;
    }
    
    //Scorro la lista fino all' elemento che precede l'ultimo elemento
    Nodo* l_corrente = p_lista->testa;
    
    while (l_corrente->next != p_lista->coda) 
	{
        l_corrente = l_corrente->next;
    }
    
    //Cancello l'ultimo elemento
    free(p_lista->coda);
    
    // Sposto il puntantore coda al nuovo ultimo elemento
    p_lista->coda = l_corrente;
    p_lista->coda->next = NULL;
}

void cancellaValore(Lista* p_lista, int p_valore) 
{
    if (listaVuota(p_lista))
	{
		return;
	}
	
    Nodo* l_corrente = p_lista->testa;
    Nodo* l_precedente = NULL;

    while (l_corrente != NULL) 
	{
		// Se ho trovato il valore da cancellare
        if (l_corrente->valore == p_valore) 
		{	
		    //IL valore da cancellare e' in testa
            if (l_precedente == NULL) 
			{
                p_lista->testa = l_corrente->next;
            } 
			else 
			{
				// Il valore da cancellare non e' in testa e
				// non e' in coda
                l_precedente->next = l_corrente->next;
            }
            
            // Il valore da cancellare e' in coda
            if (l_corrente == p_lista->coda)
			{
                p_lista->coda = l_precedente;
            }
            
            // Cancello il valore
            free(l_corrente);
            return;
        }
        
        // Scorro la lista
        l_precedente = l_corrente;
        l_corrente = l_corrente->next;
    }
}


void stampaLista(Lista* p_lista) 
{
    Nodo* l_corrente = p_lista->testa;
    
    cout<<"Testa -> ";
    
    while (l_corrente != NULL) 
	{
		cout<<l_corrente->valore<<" -> ";
        l_corrente = l_corrente->next;
    }
    
    cout<<"NULL"<<endl;
}

void liberaLista(Lista* p_lista) 
{
    Nodo* l_corrente = p_lista->testa;
    
    while (l_corrente != NULL) 
	{
        Nodo* l_temp = l_corrente;
        
        l_corrente = l_corrente->next;
        
		free(l_temp);
    }
    
    free(p_lista);
}