/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#ifndef __LISTA_H__
#define __LISTA_H__

#include <iostream>
#include <stdlib.h>
#include <stdexcept>

using namespace std;

// Definizione del nodo della lista
typedef struct Nodo {
    int          valore;  // Valore contenuto nel nodo
    struct Nodo* next;    // Puntatore al prossimo nodo
} Nodo;

// Struttura della lista con puntatore alla testa e alla coda
typedef struct Lista {
    Nodo* testa;
    Nodo* coda;
} Lista;

/*
 * Funzione crea lista
 * crea una lista vuota
 */
Lista* creaLista();

/*
 * Funzione listaVuota
 * restituisce true se la lista \'e vuota
 * altrimenti restituisce false;
 * @param Lista* p_lista
 *
 * @return  bool  (true o false)
 */
bool listaVuota(Lista* p_lista);

/*
 * Crea un nuovo elemento da
 * inserire nella lista
 *
 * @param int p_valore
 *
 * @return Nodo* l_nuovoElemento
 */
Nodo* creaNodo(int p_valore);

/*
 * Funzione aggiungiNodoInTesta
 * aggiunge un nodo alla testa della lista
 *
 * @param int   p_valore
 * @param Nodo* p_testa
 */
void aggiungiNodoInTesta(Lista* p_lista, int p_valore);

/*
 * Funzione aggiungiNodoInCoda
 * aggiunge un nodo in coda alla lista
 *
 * @param int    p_valore
 * @param Lista* p_lista
 */
void aggiungiNodoInCoda(Lista* p_lista, int p_valore);

/*
 * Funzione cancellaNodoInTesta
 * cancella il primo elemento della lista
 *
 * @param Lista* p_lista
 */
void cancellaNodoInTesta(Lista* p_lista);

/*
 * Funzione cancellaNodoInCoda
 * cancella l'ultimo elemento della lista
 *
 * @param Lista* p_lista
 */
void cancellaNodoInCoda(Lista* p_lista);

/*
 * Funzione cancellaValore
 * cancella un valore dalla lista
 *
 * @param Lista* p_lista
 * @param int    p_valore
 */
void cancellaValore(Lista* p_lista, int p_valore) ;


/*
 * Funzione stampaLista
 * stampa a video i valori nella lista
 *
 * @param Lista* p_lista
 */
void stampaLista(Lista* p_lista);

/*
 * Funzione liberaLista
 * libera la memoria allocata dalla lista
 *
 * @param Lista* p_lista
 */
void liberaLista(Lista* p_lista); 

void aggiungiInCoda(Lista* lista, int valore);

#endif // __LISTA_H__