/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>
#include "lista.h"
/* run this program using the console pauser or add your own getch, system("pause") or input loop */

int main(int argc, char** argv) {

	int    l_scelta;
	int    l_valore;
	Lista* l_lista = creaLista();

	do {
    	cout<<endl;
        cout<<"Menu:"<<endl;
        cout<<"1. Aggiungi elemento in testa"<<endl;
        cout<<"2. Aggiungi elemento in coda"<<endl;
        cout<<"3. Cancella elemento in testa"<<endl;
        cout<<"4. Cancella elemento in coda"<<endl;
        cout<<"5. Cancella un elemento preciso della lista"<<endl;
        cout<<"6. Stampa la lista"<<endl;
        cout<<"7. Esci"<<endl;
        cout<<"Scelta: ";
        cin>>l_scelta;

        switch (l_scelta) {
        	
            case 1: {
                // Aggiunge un elemnto in testa alla lista
                cout<<"Inserire il valore da aggiungere in testa alla lista: ";
                cin>>l_valore;
                cout<<endl;
                aggiungiNodoInTesta(l_lista,l_valore);
                break;
            }
            
            case 2: {
                // Aggiunge un elemnto in coda alla lista
                cout<<"Inserire il valore da aggiungere in coda alla lista: ";
                cin>>l_valore;
                cout<<endl;
                aggiungiNodoInCoda(l_lista,l_valore);
                break;
            }
            
            case 3: {
                // Cancella l' elemnto in testa alla lista
                cancellaNodoInTesta(l_lista);
                break;
            }
            
            case 4: {
                // Cancella l' elemnto in coda alla lista
                cancellaNodoInCoda(l_lista);
                break;
            }
            
            case 5: {
                 // Cancella un elemnto specifico dalla lista
                cout<<"Inserire il valore da cancellare dalla lista: ";
                cin>>l_valore;
                cout<<endl;
                cancellaValore(l_lista,l_valore);
                break;
            }
            
            case 6: {
                // Visualizza i valori della lista
                stampaLista(l_lista);
                break;
            }
            
            case 7: {
				cout<<"Uscita dal programma."<<endl;
				liberaLista(l_lista);
				free(l_lista);
                break;
			}
            
                
            default:
                cout<<"Scelta non valida!"<<endl;
        }
        
    } while (l_scelta != 7);

					
	return EXIT_SUCCESS;
}


/*
int main(int argc, char** argv) {

	Lista* l_lista = creaLista();

   	if (listaVuota(l_lista)) 
   	{
   		cout<<"La lista e' vuota"<<endl;
   	}

	cout<<"Aggiungo 10 in coda, 20 in testa e 30 in coda..."<<endl;
	
    aggiungiNodoInCoda(l_lista, 10);
    aggiungiNodoInTesta(l_lista, 20);
    aggiungiNodoInCoda(l_lista, 30);
	
	
    if(listaVuota(l_lista))
    {
      cout<<"La lista e' vuota"<<endl;
	}
	else
	{
		cout<<"La lista ha i seguneti valori:"<<endl;
		stampaLista(l_lista);
	}
	
	cout<<"Rimuovo la lista dalla memoria..."<<endl;
	liberaLista(l_lista);
				
	return EXIT_SUCCESS;
}
*/