/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include <iostream>
#include "pila.h"

int main(int argc, char** argv){
	
	int    l_scelta;
	int    l_valore;
    Stack* l_pila;  
   
   	l_pila = creaPila();
   
	do {
    	cout<<endl;
        cout<<"Menu:"<<endl;
        cout<<"1. Inserisci elemento"<<endl;
        cout<<"2. Estrai un  elemento"<<endl;
        cout<<"3. Visualizza elemento in testa"<<endl;
        cout<<"4. Stampa la Pila"<<endl;;
        cout<<"5. Esci"<<endl;
        cout<<"Scelta: ";
        cin>>l_scelta;

        switch (l_scelta) {
        	
            case 1: {
                // Aggiunge un elemnto nella Pila
                cout<<"Inserire il valore da aggiungere in testa alla lista: ";
                cin>>l_valore;
                cout<<endl;
                push(l_pila,l_valore);
                break;
            }
            
            case 2: {
                // Estrai un elemnto dalla Pila
                l_valore = pop(l_pila);
                cout<<"Valore estratto : "<<l_valore;
                cout<<endl;
                break;
            }
            
            case 3: {
                // Visualizza l' elemnto in testa alla pila
                 l_valore = peek(l_pila);
                cout<<"Valore in cima alla pila e' : "<<l_valore;
                cout<<endl;
                break;
            }
            
            case 4: {
                // Visualizza i valori della lista
                stampaPila(l_pila);
                break;
            }
            
            case 5: {
				cout<<"Uscita dal programma."<<endl;
				freePila(l_pila);
                break;
			}
            
                
            default:
                cout<<"Scelta non valida!"<<endl;
        }
        
    } while (l_scelta != 5);

					
	return EXIT_SUCCESS;
	
	
}
