/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "pila.h"

Nodo* creaNodo(int p_valore)
{
	try
	{
		Nodo* l_nuovoNodo = (Nodo*)malloc(sizeof(Nodo));
		
		 if (l_nuovoNodo == NULL) 
		 {
		 	throw runtime_error("Errore di allocazione della memoria.");
		 }
		 
		l_nuovoNodo->data = p_valore;
    	l_nuovoNodo->next   = NULL;
    	
    	return l_nuovoNodo;
	
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return NULL;
	}

}

// Crea la pila
Stack* creaPila() 
{	
	try{
		Stack* l_stack = (Stack*)malloc(sizeof(Stack));
		
		if (l_stack == NULL) 
		{
		 	throw runtime_error("Errore di allocazione della memoria.");
		}
		
    	l_stack->top = NULL;
 		
		return l_stack;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
		return NULL;
	}
    
}
/*
void creaPila(Stack* p_stack) 
{
    p_stack->top = NULL;
}
*/
// Verifica se e' vuota
bool isEmpty(Stack* p_stack) 
{
	
	if (p_stack->top == NULL)
	{
		return true;
	}
	
    return  false;
}

// PUSH: aggiunge un elemento in cima
void push(Stack* p_stack, int p_value) 
{
	
    Nodo* l_newNodo = creaNodo(p_value);
    
    if (l_newNodo==NULL)
    {
    	cout<<"Errore"<<endl;
    	return;
	}
    	
    	
    l_newNodo->next = p_stack->top;
    p_stack->top = l_newNodo;
}

// POP: rimuove l'elemento in cima
int pop(Stack* p_stack) 
{	
	Nodo* l_temp;
	int l_value;
	
	try{
		
		 if (isEmpty(p_stack)) 
		{	
        	throw runtime_error("Errore la pila e' vuota.");
    	}
		
		l_temp       = p_stack->top;
    	l_value      = l_temp->data;
    	p_stack->top = l_temp->next;
    	
    	free(l_temp);
    	
    	return l_value;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
       	return EXIT_FAILURE;
	}
}
    


// PEEK: legge l'elemento in cima
int peek(Stack* p_stack) 
{
	int l_value;
	
	try{
		
		 if (isEmpty(p_stack)) 
		 {	
        	throw runtime_error("Errore la pila e' vuota.");
    	 }
		
    	l_value = p_stack->top->data;
    	
    	return l_value;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
       	return EXIT_FAILURE;
	}
	
}

// Stampa a video gli elementi della pila
int stampaPila(Stack* p_stack) 
{
	Nodo* l_corrente;
	
		try{
		
		 if (isEmpty(p_stack)) 
		 {	
        	throw runtime_error("Errore la pila e' vuota.");
    	 }
    	 
    	l_corrente = p_stack->top;
		
    	 while (l_corrente != NULL) 
		{
			cout<<l_corrente->data<<endl;
        	l_corrente = l_corrente->next;
    	}
    	
    	return EXIT_SUCCESS;
	}
	catch(const exception& e)
	{
		cerr<<"Eccezione catturata: "<<e.what()<<endl;
       	return EXIT_FAILURE;
	}
}

// Rimuove dalla memoria la pila
void freePila(Stack* p_stack)
{
	Nodo* l_corrente = p_stack->top;
    
    while (l_corrente != NULL) 
	{
        Nodo* l_temp = l_corrente;
        
        l_corrente = l_corrente->next;
        
        free(l_temp);
    }
    
    free(p_stack);	
}