/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#ifndef __PILA_H__
#define __PILA_H__

#include <iostream>
#include <stdlib.h>
#include <stdexcept>

using namespace std;

// Definizione del Nodo della pila
typedef struct Nodo {
    int data;
    struct Nodo* next;
} Nodo;

// Definizione della struttura dati Pila
typedef struct Stack {
    Nodo* top;
} Stack;


/*
 * Crea un nuovo elemento da
 * inserire nella lista
 *
 * @param int p_valore
 *
 * @return Nodo* l_nuovoElemento
 */
Nodo* creaNodo(int p_valore);


// Operazioni del tipo dato Pila

/*
 * Funzione creaPila 
 * Crea la pila vuota
 *
 * @return  Stack* p_stack
 */
Stack* creaPila();

/*
 * Funzione isEmpty
 * Verifica se la pila e' vuota
 *
 * @param Stack* p_stack
 *
 * @return true/false
 */
 bool isEmpty(Stack* p_stack);
 
 /*
  * Funzione PUSH
  * Inserisce un elemento all' interno della Pila
  *
  * @param Stack* p_stack
  * @param int    p_value
  */
 void push(Stack* p_stack, int p_value);
 
 /*
  * Funzione POP
  * Rimuove un elemento dalla pila
  * e lo restituisce
  *
  * @param Stack* p_stack
  *
  * @return int l_value
  */
 int pop(Stack* p_stack);

/*
 * Funzione PEEK
 * Restituisce l'elemento che verrebbe rimosso
 * con il comando POP senza rimuoverlo dalla Pila
 *
 * @param Stack* p_stack
 *
 * @return int l_value
 */
int peek(Stack* p_stack);


/*
 * Funzione stampaPila
 * Stampa il contenuto della pila
 *
 * @param Stack* p_stack
 *
 * @return int EXIT_SUCCESS/EXIT_FAILURE
 */
int stampaPila(Stack* p_stack) ;

/*
 * Funzione freePila
 * Cancella la pila dalla memoria
 *
 * @param Stack* p_stack
 */
void freePila(Stack* p_stack);

#endif //__PILA_H__