/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#include "rubrica.h"

// Aggiungi contatto con timestamp
void aggiungiContatto(char const* p_nomeFile) 
{
	// Apertura del file in scrittura
    ofstream l_outStream(p_nomeFile, ios::binary | ios::app);
    
	Contatto l_nuovoContatto;

    cout << "Nome: "; 
    cin>>l_nuovoContatto.nome;
	cout<<endl;	
    cout << "Cognome: "; 
	cin>>l_nuovoContatto.cognome;
	cout<<endl;	
    cout << "Telefono: "; 
	cin>>l_nuovoContatto.telefono;
	cout<<endl;	
    cout << "Email: "; 
	cin>>l_nuovoContatto.email;

	// Aggiunta dell'ora in cui si e' inserito il contatto nella rubrica
    time_t l_now = time(nullptr);
    strftime(l_nuovoContatto.timestamp, sizeof(l_nuovoContatto.timestamp), 
	         "%Y-%m-%d %H:%M:%S", localtime(&l_now));
	         
	// Si scrive sul file il nuovo contatto
    l_outStream.write(reinterpret_cast<char*>(&l_nuovoContatto), sizeof(l_nuovoContatto));
    
    // Si chiude il file ad operazioni finite.
    l_outStream.close();
}

// Visualizza tutti i contatti
void visualizzaContatti(char const* p_nomeFile) 
{
	// Apertura del file in lettura
    ifstream l_inStream(p_nomeFile, ios::binary);
    
    Contatto l_contatto;
    int      l_count = 0;

    cout << "Elenco dei contatti:"<<endl;
    while (l_inStream.read(reinterpret_cast<char*>(&l_contatto), sizeof(l_contatto))) {
        cout << ++l_count << ") " << l_contatto.nome << " " << l_contatto.cognome
             << " | Tel: " << l_contatto.telefono << " | Email: " << l_contatto.email
             << " | Data: " << l_contatto.timestamp << endl;
    }
    
    // Si chiude il file ad operazioni finite.
    l_inStream.close();
    
    if (l_count == 0) 
    {
		cout << "Nessun contatto presente."<<endl;
	}
}

// Modifica contatto
void modificaContatto(char const* p_nomeFile, char* p_nomeDaModificare) 
{
	// Apertura del file in lettura e scrittura
	fstream  l_file(p_nomeFile, ios::in | ios::out | ios::binary);
    
	Contatto l_contatto;
    bool     l_trovato = false;

    while (l_file.read(reinterpret_cast<char*>(&l_contatto), sizeof(l_contatto))) 
	{
        if (strcmp(l_contatto.nome, p_nomeDaModificare) == 0) 
		{
            cout << "Nuovo nome: "; 
			cin>>l_contatto.nome;
			cout<<endl;	
            cout << "Nuovo cognome: "; 
			cin>>l_contatto.cognome;
			cout<<endl;	
            cout << "Nuovo telefono: "; 
			cin>>l_contatto.telefono;
			cout<<endl;	
            cout << "Nuova email: "; 
			cin>>l_contatto.email;

            time_t l_now = time(nullptr);
            strftime(l_contatto.timestamp, sizeof(l_contatto.timestamp),
			         "%Y-%m-%d %H:%M:%S", localtime(&l_now));

            l_file.seekp(-static_cast<int>(sizeof(l_contatto)), ios::cur);
            l_file.write(reinterpret_cast<char*>(&l_contatto), sizeof(l_contatto));
            l_trovato = true;
            break;
        }
    }

  	// Si chiude il file ad operazioni finite.
    l_file.close();
    
    if (l_trovato == false)
    {
    	cout<<"Contatto non trovato."<<endl;
	}
}

// Cancella contatto
void cancellaContatto(char const* p_nomeFile, char* p_nomeDaCancellare) 
{
	// Apertura del file in lettura
    ifstream l_inStream(p_nomeFile, ios::binary);
    
    // Apertura del file temp in scrittura
    ofstream l_temp("temp.dat", ios::binary);
    
    Contatto l_contatto;
    bool     l_cancellato = false;

    while (l_inStream.read(reinterpret_cast<char*>(&l_contatto), sizeof(l_contatto))) 
	{
        if (strcmp(l_contatto.nome, p_nomeDaCancellare) != 0) 
		{
			// Scrivo sul file temporaneo tutti i nomi della rubrica
			// diversi da quello che voglio cancellare
            l_temp.write(reinterpret_cast<char*>(&l_contatto), sizeof(l_contatto));
        } 
		else 
		{
            l_cancellato = true;
        }
    }

	  // Si chiudono entrambi i file ad operazioni finite.
    l_inStream.close(); 
	l_temp.close();
	
	// Si rimuove il file della rubrica vecchia
    remove(p_nomeFile);
    // Si rinomina il file temp con il nome del file
    // contenente la rubrica.
    rename("temp.dat", p_nomeFile);
    
    if (l_cancellato== false)
    {
    	cout<<"Contatto non trovato."<<endl;
	}
}

// Esporta in CSV
void esportaCSV(char const* p_nomeBinario, char* p_nomeCSV)
 {
 	// Apertura del file in lettura
    ifstream l_inStream(p_nomeBinario, ios::binary);
    
    // Apertura del file csv in scrittura
    ofstream l_outStream(p_nomeCSV);
    
    Contatto l_contatto;

	// Si scrive intestazione delle colonnne del file csv
    l_outStream << "Nome,Cognome,Telefono,Email,Timestamp\n";
    
    // Si trasferiscono i dati della rubrica nel file csv 
    while (l_inStream.read(reinterpret_cast<char*>(&l_contatto), sizeof(l_contatto)))
	{
        l_outStream << l_contatto.nome << "," << l_contatto.cognome << "," 
		            << l_contatto.telefono
                    << "," << l_contatto.email 
					<< "," << l_contatto.timestamp << "\n";
    }

	// Si chiudono entrambi i file ad operazioni finite.
    l_inStream.close(); 
	l_outStream.close();
	
    cout<<"Esportazione completata in "<< p_nomeCSV<<endl;
}
