/* Codice del libro "Dal Problema al Codice C++"
 *
 * Author        : Pino Ruffilli
 *
 * Email         : pino.ruffilli@gmail.com
 *
 * Last revision : 2025/05/02
 *
 * Copyright 2025 Pino Ruffilli, Italy. All rights reserved
 *
 */

#ifndef   __RUBRICA_H__
#define   __RUBRICA_H__

#include <iostream>
#include <fstream>
#include <vector>
#include <algorithm>
#include <cstring>
#include <ctime>
using namespace std;

// Definizione della struttura Contatto
typedef struct Contatto {
    char nome[30];
    char cognome[30];
    char telefono[20];
    char email[50];
    char timestamp[30]; // data/ora di registrazione
}Contatto;

/*
 * Funzione aggiungiContatto
 * Aggiunge un contatto alla rubrica
 * memorizzata nel file con nome p_nomeFile
 *
 * @param char* p_nomeFile
 */
void aggiungiContatto(char const* p_nomeFile);

/*
 * Funzione visualizzaContatti
 * Permette di visualizzare i contatti presenti
 * in rubrica
 *
 * @param char* p_nomeFile
 */
void visualizzaContatti(char const* p_nomeFile);

/*
 * Funzione modificaContatto
 * Permette di modificare un cottato gia' 
 * presente in rubrica
 *
 * @param char* p_nomeFile
 * @parma char* p_nomeDaModificare
 */
void modificaContatto(char const* p_nomeFile, char* p_nomeDaModificare);

/*
 * Funzione cancellaContatto
 * Permette di cancellare un contatto dalla rubrica
 *
 * @param char* p_nomeFile
 * @parma char* p_nomeDaCancellare
 */
void cancellaContatto(char const* p_nomeFile, char* p_nomeDaCancellare);

/*
 * Funzione esportaCSV
 * Esporta la rubrica in un file csv
 *
 * @param char* p_nomeBinario
 * @param char* p_nomeCSV
 */
void esportaCSV(char const* p_nomeBinario, char* p_nomeCSV);

#endif // __RUBRICA_H__